<?php
/* --------------------------------------------------------------
 Language.php 2020-02-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel\Bootstrapper\Language;

use Webmozart\Assert\Assert;

/**
 * Class Language
 * @package Gambio\Admin\Application\Middleware\Language
 */
class Language
{
    /**
     * @var string
     */
    private $directory;
    
    /**
     * @var string
     */
    private $id;
    
    /**
     * @var string
     */
    private $charset;
    
    /**
     * @var string
     */
    private $code;
    
    
    /**
     * Language constructor.
     *
     * @param string $directory
     * @param string $id
     * @param string $charset
     * @param string $code
     */
    private function __construct(string $directory, string $id, string $charset, string $code)
    {
        $this->directory = $directory;
        $this->id        = $id;
        $this->charset   = $charset;
        $this->code      = $code;
    }
    
    
    /**
     * Factory method for Language.
     *
     * @param array $languageData
     *
     * @return static
     */
    public static function fromArray(array $languageData): self
    {
        Assert::keyExists($languageData, 'directory');
        Assert::keyExists($languageData, 'languages_id');
        Assert::keyExists($languageData, 'language_charset');
        Assert::keyExists($languageData, 'code');
        
        return new static($languageData['directory'],
                          $languageData['languages_id'],
                          $languageData['language_charset'],
                          $languageData['code']);
    }
    
    
    /**
     * @return string
     */
    public function directory(): string
    {
        return $this->directory;
    }
    
    
    /**
     * @return string
     */
    public function id(): string
    {
        return $this->id;
    }
    
    
    /**
     * @return string
     */
    public function charset(): string
    {
        return $this->charset;
    }
    
    
    /**
     * @return string
     */
    public function code(): string
    {
        return $this->code;
    }
}